/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.object;

import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public class DeferredCache<I, O> {
    private boolean computed = false;
    private final Function<I, O> mappingFunction;
    private @Nullable I input;
    private @Nullable O output = null;

    public DeferredCache(I input, Function<I, O> mappingFunction) {
        this.input = Objects.requireNonNull(input);
        this.mappingFunction = mappingFunction;
    }

    public I getInput() {
        if (this.computed || this.input == null) {
            throw new IllegalStateException("Attempting to access input after output of deferred cache has been calculated!");
        }
        return this.input;
    }

    public O getOutput() {
        if (!this.computed || this.output == null) {
            throw new IllegalStateException("Attempting to access output before it has been calculated!");
        }
        return this.output;
    }

    public O compute() {
        if (!this.computed) {
            this.output = this.mappingFunction.apply(Objects.requireNonNull(this.input));
            this.input = null;
            this.computed = true;
        }
        return this.getOutput();
    }
}

